#!/bin/bash
#
# Resolve the location of the SmartSynchronize installation.
# This includes resolving any symlinks.
PRG=$0
while [ -h "$PRG" ]; do
    ls=`ls -ld "$PRG"`
    link=`expr "$ls" : '^.*-> \(.*\)$' 2>/dev/null`
    if expr "$link" : '^/' 2> /dev/null >/dev/null; then
        PRG="$link"
    else
        PRG="`dirname "$PRG"`/$link"
    fi
done

SMARTSYNCHRONIZE_BIN=`dirname "$PRG"`

# absolutize dir
oldpwd=`pwd`
cd "${SMARTSYNCHRONIZE_BIN}"
SMARTSYNCHRONIZE_BIN=`pwd`
cd "${oldpwd}"

ICON_NAME=syntevo-smartsynchronize
TMP_DIR=`mktemp --directory`
DESKTOP_FILE=$TMP_DIR/syntevo-smartsynchronize.desktop
cat << EOF > $DESKTOP_FILE
[Desktop Entry]
Version=1.0
Name=SmartSynchronize
Keywords=file;compare;merge
Comment=File Manager and File/Directory Compare Tool
Type=Application
Categories=Development
Terminal=false
StartupWMClass=SmartSynchronize
Exec="$SMARTSYNCHRONIZE_BIN/smartsynchronize.sh"
Icon=$ICON_NAME
EOF

# seems necessary to refresh immediately:
chmod 644 $DESKTOP_FILE

wslCopyFileTo() {
    SRC_PATH=$1
    DST_PATH=$2
    DST_FOLDER=$(dirname $DST_PATH)
    if [ ! -d "$DST_FOLDER" ]; then
        mkdir -p "$DST_FOLDER"
    fi

    if ! cp -f "$SRC_PATH" "$DST_PATH"; then
        echo "WSL only creates Windows shortcuts for system desktop entries."
        echo "Please re-run this script with sudo."
        exit 1
    fi
}

if [ "Ubuntu" = "$WSL_DISTRO_NAME" ]; then
    # On WSL, there are a few issues:
    # 1) 'xdg-desktop-menu' is not available by default
    # 2) 'xdg-desktop-menu' fails unless '/usr/share/desktop-directories' is created manually
    # 3) 'xdg-desktop-menu' is ignored when run without sudo.
    # The workaround is to just use known file locations.
    XDG_DESKTOP_PATH="/usr/share/applications"
    XDG_ICON_PATH="/usr/share/icons/hicolor"

    wslCopyFileTo "$SMARTSYNCHRONIZE_BIN/smartsynchronize-32.png"  "$XDG_ICON_PATH/32x32/apps/$ICON_NAME.png"
    wslCopyFileTo "$SMARTSYNCHRONIZE_BIN/smartsynchronize-48.png"  "$XDG_ICON_PATH/48x48/apps/$ICON_NAME.png"
    wslCopyFileTo "$SMARTSYNCHRONIZE_BIN/smartsynchronize-64.png"  "$XDG_ICON_PATH/64x64/apps/$ICON_NAME.png"
    wslCopyFileTo "$SMARTSYNCHRONIZE_BIN/smartsynchronize-128.png" "$XDG_ICON_PATH/128x128/apps/$ICON_NAME.png"
    wslCopyFileTo "$DESKTOP_FILE" "$XDG_DESKTOP_PATH/syntevo-smartsynchronize.desktop"
else
    xdg-icon-resource install --size  32 "$SMARTSYNCHRONIZE_BIN/smartsynchronize-32.png"  $ICON_NAME
    xdg-icon-resource install --size  48 "$SMARTSYNCHRONIZE_BIN/smartsynchronize-48.png"  $ICON_NAME
    xdg-icon-resource install --size  64 "$SMARTSYNCHRONIZE_BIN/smartsynchronize-64.png"  $ICON_NAME
    xdg-icon-resource install --size 128 "$SMARTSYNCHRONIZE_BIN/smartsynchronize-128.png" $ICON_NAME
    xdg-desktop-menu install $DESKTOP_FILE
fi

rm $DESKTOP_FILE
rm -R $TMP_DIR
