/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.DPIZoomChangeRegistry;
import org.eclipse.swt.internal.win32.ACCEL;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.MENUBARINFO;
import org.eclipse.swt.internal.win32.MENUINFO;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Widget;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    long hBitmap;
    int id;
    int accelerator;
    int userId;
    int index;
    ToolTip itemToolTip;
    static final int MARGIN_WIDTH = 1;
    static final int MARGIN_HEIGHT = 1;

    public MenuItem(Menu parent, int style) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        this.index = parent.getItemCount();
        parent.createItem(this, this.index);
    }

    public MenuItem(Menu parent, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        this.index = index;
        parent.createItem(this, this.index);
    }

    MenuItem(Menu parent, Menu menu, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        this.menu = menu;
        this.index = index;
        if (menu != null) {
            menu.cascade = this;
        }
        this.display.addMenuItem(this);
    }

    public void addArmListener(ArmListener listener) {
        this.addTypedListener(listener, 30);
    }

    public void addHelpListener(HelpListener listener) {
        this.addTypedListener(listener, 28);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener(listener, 13, 14);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int style) {
        return MenuItem.checkBits(style, 8, 32, 16, 2, 64, 0);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    boolean fillAccel(ACCEL accel) {
        accel.fVirt = 0;
        accel.cmd = accel.key = (short)0;
        if (this.accelerator == 0 || !this.getEnabled()) {
            return false;
        }
        if ((this.accelerator & 0x400000) != 0) {
            return false;
        }
        boolean fVirt = true;
        int key = this.accelerator & 0x100FFFF;
        int vKey = Display.untranslateKey(key);
        if (vKey != 0) {
            key = vKey;
        } else {
            switch (key) {
                case 27: {
                    key = 27;
                    break;
                }
                case 127: {
                    key = 46;
                    break;
                }
                default: {
                    if (key == 0) {
                        return false;
                    }
                    vKey = OS.VkKeyScan((short)key);
                    if (vKey == -1) {
                        if (key == (int)OS.CharUpper(OS.LOWORD(key))) break;
                        fVirt = false;
                        break;
                    }
                    key = vKey & 0xFF;
                }
            }
        }
        accel.key = (short)key;
        accel.cmd = (short)this.id;
        accel.fVirt = (byte)(fVirt ? 1 : 0);
        if ((this.accelerator & 0x10000) != 0) {
            accel.fVirt = (byte)(accel.fVirt | 0x10);
        }
        if ((this.accelerator & 0x20000) != 0) {
            accel.fVirt = (byte)(accel.fVirt | 4);
        }
        if ((this.accelerator & 0x40000) != 0) {
            accel.fVirt = (byte)(accel.fVirt | 8);
        }
        return true;
    }

    void fixMenus(Decorations newParent) {
        if (this.menu != null && !this.menu.isDisposed() && !newParent.isDisposed()) {
            this.menu.fixMenus(newParent);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    Rectangle getBounds() {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        if ((this.parent.style & 2) != 0) {
            Decorations shell = this.parent.parent;
            if (shell.menuBar != this.parent) {
                return new Rectangle(0, 0, 0, 0);
            }
            long hwndShell = shell.handle;
            MENUBARINFO info1 = new MENUBARINFO();
            info1.cbSize = MENUBARINFO.sizeof;
            if (!OS.GetMenuBarInfo(hwndShell, -3, 1, info1)) {
                return new Rectangle(0, 0, 0, 0);
            }
            MENUBARINFO info2 = new MENUBARINFO();
            info2.cbSize = MENUBARINFO.sizeof;
            if (!OS.GetMenuBarInfo(hwndShell, -3, index + 1, info2)) {
                return new Rectangle(0, 0, 0, 0);
            }
            int x = info2.left - info1.left;
            int y = info2.top - info1.top;
            int width = info2.right - info2.left;
            int height = info2.bottom - info2.top;
            return new Rectangle(x, y, width, height);
        }
        long hMenu = this.parent.handle;
        RECT rect1 = new RECT();
        if (!OS.GetMenuItemRect(0L, hMenu, 0, rect1)) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rect2 = new RECT();
        if (!OS.GetMenuItemRect(0L, hMenu, index, rect2)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int x = rect2.left - rect1.left + 2;
        int y = rect2.top - rect1.top + 2;
        int width = rect2.right - rect2.left;
        int height = rect2.bottom - rect2.top;
        return new Rectangle(x, y, width, height);
    }

    public boolean getEnabled() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return (this.state & 8) == 0;
        }
        long hMenu = this.parent.handle;
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 1;
        boolean success = OS.GetMenuItemInfo(hMenu, this.id, false, info);
        if (!success) {
            this.error(31);
        }
        return (info.fState & 3) == 0;
    }

    public int getID() {
        this.checkWidget();
        return this.userId;
    }

    @Override
    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    @Override
    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        long hMenu = this.parent.handle;
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 1;
        boolean success = OS.GetMenuItemInfo(hMenu, this.id, false, info);
        if (!success) {
            this.error(9);
        }
        return (info.fState & 8) != 0;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.itemToolTip == null || this.itemToolTip.isDisposed() ? null : this.itemToolTip.getMessage();
    }

    void hideToolTip() {
        if (this.itemToolTip == null || this.itemToolTip.isDisposed()) {
            return;
        }
        this.itemToolTip.setVisible(false);
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    @Override
    void releaseChildren(boolean destroy) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
        this.id = -1;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.hBitmap != 0L) {
            OS.DeleteObject(this.hBitmap);
        }
        this.hBitmap = 0L;
        if (this.accelerator != 0) {
            this.parent.destroyAccelerators();
        }
        this.accelerator = 0;
        if (this.itemToolTip != null && !this.itemToolTip.isDisposed()) {
            this.itemToolTip.setVisible(false);
            this.itemToolTip.dispose();
            this.itemToolTip = null;
        }
        this.display.removeMenuItem(this);
    }

    public void removeArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    @Override
    void reskinChildren(int flags) {
        if (this.menu != null) {
            this.menu.reskin(flags);
        }
        super.reskinChildren(flags);
    }

    void selectRadio() {
        MenuItem[] items = this.parent.getItems();
        for (int index = 0; index < items.length && items[index] != this; ++index) {
        }
        for (int i = index - 1; i >= 0 && items[i].setRadioSelection(false); --i) {
        }
        for (int j = index + 1; j < items.length && items[j].setRadioSelection(false); ++j) {
        }
        this.setSelection(true);
    }

    public void setAccelerator(int accelerator) {
        this.checkWidget();
        if (this.accelerator == accelerator) {
            return;
        }
        this.accelerator = accelerator;
        this.parent.destroyAccelerators();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            this.state = enabled ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        }
        long hMenu = this.parent.handle;
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 1;
        boolean success = OS.GetMenuItemInfo(hMenu, this.id, false, info);
        if (!success) {
            int error = OS.GetLastError();
            SWT.error(30, null, " [GetLastError=0x" + Integer.toHexString(error) + "]");
        }
        int bits = 3;
        if (enabled) {
            if ((info.fState & bits) == 0) {
                return;
            }
            info.fState &= ~bits;
        } else {
            if ((info.fState & bits) == bits) {
                return;
            }
            info.fState |= bits;
        }
        success = OS.SetMenuItemInfo(hMenu, this.id, false, info);
        if (!success) {
            boolean bl = success = this.id == OS.GetMenuDefaultItem(hMenu, 0, 1);
            if (!success) {
                int error = OS.GetLastError();
                SWT.error(30, null, " [GetLastError=0x" + Integer.toHexString(error) + "]");
            }
        }
        this.parent.destroyAccelerators();
        this.parent.redraw();
    }

    public void setID(int id) {
        this.checkWidget();
        if (id < 0) {
            this.error(5);
        }
        this.userId = id;
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (this.image == image) {
            return;
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 128;
        if (this.parent.needsMenuCallback()) {
            info.hbmpItem = -1L;
        } else if (OS.IsAppThemed()) {
            if (this.hBitmap != 0L) {
                OS.DeleteObject(this.hBitmap);
            }
            this.hBitmap = image != null ? Display.create32bitDIB(image) : 0L;
            info.hbmpItem = this.hBitmap;
        } else {
            info.hbmpItem = image != null ? -1L : 0L;
        }
        long hMenu = this.parent.handle;
        OS.SetMenuItemInfo(hMenu, this.id, false, info);
        this.parent.redraw();
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        this.setMenu(menu, false);
    }

    void setMenu(Menu menu, boolean dispose) {
        Menu oldMenu = this.menu;
        if (oldMenu == menu) {
            return;
        }
        if (oldMenu != null) {
            oldMenu.cascade = null;
        }
        this.menu = menu;
        long hMenu = this.parent.handle;
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 32;
        int index = 0;
        while (OS.GetMenuItemInfo(hMenu, index, true, info) && info.dwItemData != (long)this.id) {
            ++index;
        }
        if (info.dwItemData != (long)this.id) {
            return;
        }
        int cch = 128;
        long hHeap = OS.GetProcessHeap();
        int byteCount = cch * 2;
        long pszText = OS.HeapAlloc(hHeap, 8, byteCount);
        info.fMask = 35;
        info.fMask |= 0xC0;
        info.dwTypeData = pszText;
        info.cch = cch;
        boolean success = OS.GetMenuItemInfo(hMenu, index, true, info);
        if (menu != null) {
            menu.cascade = this;
            info.fMask |= 4;
            info.hSubMenu = menu.handle;
        }
        if (dispose || oldMenu == null) {
            success = OS.SetMenuItemInfo(hMenu, index, true, info);
        } else {
            OS.RemoveMenu(hMenu, index, 1024);
            success = OS.InsertMenuItem(hMenu, index, true, info);
        }
        if (pszText != 0L) {
            OS.HeapFree(hHeap, 0, pszText);
        }
        if (!success) {
            int error = OS.GetLastError();
            SWT.error(29, null, " [GetLastError=0x" + Integer.toHexString(error) + "]");
        }
        this.parent.destroyAccelerators();
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    void setOrientation(int orientation) {
        long hMenu = this.parent.handle;
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 256;
        info.fType = this.widgetStyle();
        OS.SetMenuItemInfo(hMenu, this.id, false, info);
        if (this.menu != null) {
            this.menu._setOrientation(orientation);
        }
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        long hMenu = this.parent.handle;
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        info.fMask = 1;
        boolean success = OS.GetMenuItemInfo(hMenu, this.id, false, info);
        if (!success) {
            this.error(28);
        }
        info.fState &= 0xFFFFFFF7;
        if (selected) {
            info.fState |= 8;
        }
        if (!(success = OS.SetMenuItemInfo(hMenu, this.id, false, info))) {
            boolean bl = success = this.id == OS.GetMenuDefaultItem(hMenu, 0, 1);
            if (!success) {
                int error = OS.GetLastError();
                SWT.error(28, null, " [GetLastError=0x" + Integer.toHexString(error) + "]");
            }
        }
        this.parent.redraw();
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        long hHeap = OS.GetProcessHeap();
        long pszText = 0L;
        MENUITEMINFO info = new MENUITEMINFO();
        info.cbSize = MENUITEMINFO.sizeof;
        long hMenu = this.parent.handle;
        TCHAR buffer = new TCHAR(0, string, true);
        int byteCount = buffer.length() * 2;
        pszText = OS.HeapAlloc(hHeap, 8, byteCount);
        OS.MoveMemory(pszText, buffer, byteCount);
        info.fMask = 64;
        info.dwTypeData = pszText;
        boolean success = OS.SetMenuItemInfo(hMenu, this.id, false, info);
        if (pszText != 0L) {
            OS.HeapFree(hHeap, 0, pszText);
        }
        if (!success) {
            int error = OS.GetLastError();
            SWT.error(13, null, " [GetLastError=0x" + Integer.toHexString(error) + "]");
        }
        this.parent.redraw();
    }

    public void setToolTipText(String toolTip) {
        this.checkWidget();
        if (toolTip == null && this.itemToolTip != null) {
            if (!this.itemToolTip.isDisposed()) {
                this.itemToolTip.setVisible(false);
                this.itemToolTip.dispose();
            }
            this.itemToolTip = null;
        }
        if (toolTip == null || toolTip.trim().length() == 0 || this.itemToolTip != null && !this.itemToolTip.isDisposed() && toolTip.equals(this.itemToolTip.getMessage())) {
            return;
        }
        if (this.itemToolTip != null) {
            this.itemToolTip.dispose();
        }
        this.itemToolTip = new MenuItemToolTip(this.getParent().getShell());
        this.itemToolTip.setMessage(toolTip);
        this.itemToolTip.setVisible(false);
    }

    void showTooltip(int x, int y) {
        if (this.itemToolTip == null || this.itemToolTip.isDisposed()) {
            return;
        }
        this.itemToolTip.setLocationInPixels(x, y);
        this.itemToolTip.setVisible(true);
    }

    int widgetStyle() {
        int bits = 0;
        Decorations shell = this.parent.parent;
        if ((shell.style & 0x8000000) != 0) {
            if ((this.parent.style & 0x2000000) != 0) {
                bits |= 0x6000;
            }
        } else if ((this.parent.style & 0x4000000) != 0) {
            bits |= 0x6000;
        }
        if ((this.style & 2) != 0) {
            return bits | 0x800;
        }
        if ((this.style & 0x10) != 0) {
            return bits | 0x200;
        }
        return bits | 0;
    }

    LRESULT wmCommandChild(long wParam, long lParam) {
        if ((this.style & 0x20) != 0) {
            this.setSelection(!this.getSelection());
        } else if ((this.style & 0x10) != 0) {
            if ((this.parent.getStyle() & 0x400000) != 0) {
                this.setSelection(!this.getSelection());
            } else {
                this.selectRadio();
            }
        }
        this.sendSelectionEvent(13);
        return null;
    }

    LRESULT wmDrawChild(long wParam, long lParam) {
        DRAWITEMSTRUCT struct = new DRAWITEMSTRUCT();
        OS.MoveMemory(struct, lParam, DRAWITEMSTRUCT.sizeof);
        if (this.image != null) {
            GCData data = new GCData();
            data.device = this.display;
            GC gc = GC.win32_new(struct.hDC, data);
            int x = (this.parent.style & 2) != 0 ? 2 : struct.left;
            Image image = this.getEnabled() ? this.image : new Image((Device)this.display, this.image, 1);
            gc.drawImage(image, DPIUtil.autoScaleDown(x), DPIUtil.autoScaleDown(struct.top + 1));
            if (this.image != image) {
                image.dispose();
            }
            gc.dispose();
        }
        if (this.parent.foreground != -1) {
            OS.SetTextColor(struct.hDC, this.parent.foreground);
        }
        return null;
    }

    LRESULT wmMeasureChild(long wParam, long lParam) {
        MEASUREITEMSTRUCT struct = new MEASUREITEMSTRUCT();
        OS.MoveMemory(struct, lParam, MEASUREITEMSTRUCT.sizeof);
        if ((this.parent.style & 2) != 0 && this.parent.needsMenuCallback()) {
            struct.itemWidth = DPIUtil.autoScaleUpUsingNativeDPI(5);
            OS.MoveMemory(lParam, struct, MEASUREITEMSTRUCT.sizeof);
            return null;
        }
        int width = 0;
        int height = 0;
        if (this.image != null) {
            Rectangle rect = this.image.getBoundsInPixels();
            width = rect.width;
            height = rect.height;
        } else {
            MENUINFO lpcmi = new MENUINFO();
            lpcmi.cbSize = MENUINFO.sizeof;
            lpcmi.fMask = 16;
            long hMenu = this.parent.handle;
            OS.GetMenuInfo(hMenu, lpcmi);
            if ((lpcmi.dwStyle & 0x4000000) == 0) {
                for (MenuItem item : this.parent.getItems()) {
                    if (item.image == null) continue;
                    Rectangle rect = item.image.getBoundsInPixels();
                    width = Math.max(width, rect.width);
                }
            }
        }
        if (width != 0 || height != 0) {
            struct.itemWidth = width + 2;
            struct.itemHeight = height + 2;
            OS.MoveMemory(lParam, struct, MEASUREITEMSTRUCT.sizeof);
        }
        return null;
    }

    private static void handleDPIChange(Widget widget, int newZoom, float scalingFactor) {
        Menu subMenu;
        if (!(widget instanceof MenuItem)) {
            return;
        }
        MenuItem menuItem = (MenuItem)widget;
        Image menuItemImage = menuItem.getImage();
        if (menuItemImage != null) {
            Image currentImage = menuItemImage;
            menuItem.image = null;
            menuItem.setImage(Image.win32_new(currentImage, newZoom));
        }
        if ((subMenu = menuItem.getMenu()) != null) {
            DPIZoomChangeRegistry.applyChange(subMenu, newZoom, scalingFactor);
        }
    }

    static {
        DPIZoomChangeRegistry.registerHandler(MenuItem::handleDPIChange, MenuItem.class);
    }

    private static final class MenuItemToolTip
    extends ToolTip {
        public MenuItemToolTip(Shell parent) {
            super(parent, 0);
            this.maybeEnableDarkSystemTheme(this.hwndToolTip());
        }

        @Override
        long hwndToolTip() {
            return this.parent.menuItemToolTipHandle();
        }
    }
}

